// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the SCTSEDLL_EXPORTS
// symbol defined on the command line. This symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// SCTSEDLL_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifdef SCTSEDLL_EXPORTS
#define SCTSEDLL_API __declspec(dllexport)
#else
#define SCTSEDLL_API __declspec(dllimport)
#endif

// MV: Memory Card Power Controlled by SDHC
// VBAT: Extra Tunable VBAT Rail
// 
// SCTS-E Power Mode 
// SCTSECTL_PWRMODE_NORMAL : 
//		VBAT/MV Controlled By SDHC 
// SCTSECTL_PWRMODE_VBAT_INSON : 
//		VBAT on When Card Insert, MV Controlled By SDHC
// SCTSECTL_PWRMODE_VBAT_FORCEON : [for debug]
//		Force VBAT on, MV Controlled By SDHC 


#define SCTSECTL_PWRMODE_NORMAL			 		0
#define SCTSECTL_PWRMODE_VBAT_INSON		 	1
#define SCTSECTL_PWRMODE_VBAT_FORCEON 	2
#define SCTSECTL_PWRMODE_ALL_FORCEON 	3
#define SCTSECTL_PWRMODE_ALL_FORCEOFF 	4

// VBAT Voltage Limit 
#define SCTSECTL_VBAT_MAX_VOLT 	4.6
#define SCTSECTL_VBAT_MIN_VOLT 	1.8
// VBAT/MV Current Limit 
#define SCTSECTL_OC_MAX_AMP 	1.0
#define SCTSECTL_OC_MIN_AMP 	0.2
// GPIO Pins 
#define SCTSECTL_DUTCTL0	0
#define SCTSECTL_DUTCTL1	1
// OC_RAIL 
#define SCTSECTL_OCRAIL_MV		0
#define SCTSECTL_OCRAIL_VBAT	1

// This class is exported from the SCTSEDll.dll
class SCTSEDLL_API CSCTSEDll {
public:
	void GETLIBVER(int* major, int* minor);
	int SCTSECTL_OPEN();
	int SCTSECTL_OPEN(int addr);
	int SCTSECTL_CLOSE();
	int SCTSECTL_BEEP(int msec, int freq);
	int SCTSECTL_LEDGO();
	int SCTSECTL_LEDNG();
	int SCTSECTL_LEDOFF();
	int SCTSECTL_MEAS_MV_VOLTAGE(double* volt);
	int SCTSECTL_MEAS_MV_CURRENT(double* amp);
	int SCTSECTL_MEAS_VBAT_VOLTAGE(double* volt);
	int SCTSECTL_MEAS_VBAT_CURRENT(double* amp);	
	int SCTSECTL_CHECKSDCD();
	int SCTSECTL_GPIOSET(int pinno);
	int SCTSECTL_GPIORESET(int pinno);
	int SCTSECTL_MCARD_DISCONNECT();
	int SCTSECTL_MCARD_NORMAL();
	int SCTSECTL_MCARD_CHECKOC();
	int SCTSECTL_MCARD_POWERMODE(int mode); 
	int SCTSECTL_SET_VBAT(double volt); 
	int SCTSECTL_SET_VBAT_OC(double ilimit);
	int SCTSECTL_SET_MV_OC(double ilimit);
	int SCTSECTL_SEL_OC_RAIL(int vbat_mcardv); 
	int SCTSECTL_SAVE_CONFIG(); 
	int SCTSECTL_GET_SN(DWORD* val);
	int SCTSECTL_GET_VBAT(double *volt); 
	int SCTSECTL_GET_VBAT_OC(double *ilimit);
	int SCTSECTL_GET_MV_OC(double *ilimit);
	int SCTSECTL_GET_OC_RAIL(int *vbat_mcardv); 	
	int SCTSCTL_PON(); 
	int SCTSCTL_POFF();
};